using System;
using CsGL.OpenGL;

namespace SPStudio
{
	/// <summary>
	/// Contains x,y,z components.
	/// Knows its validity with
	/// respect to the 4 regions.
	/// Knows how to draw itself
	/// in OpenGL.
	/// </summary>
	public class Vector3D: Renderable
	{
		#region Public Vars
		public double x = 0.0;
		public double y = 0.0;
		public double z = 0.0;

		public bool in0to90 = true;
		public bool in90to180 = true;
		public bool in180to270 = true;
		public bool in270to360 = true;
		#endregion

		#region Constructors
		/// <summary>
		/// Constructor that
		/// leaves x,y,z and state
		/// components at their default
		/// values.
		/// </summary>
		public Vector3D()
		{
		}

		/// <summary>
		/// Convert the int x,y,z to
		/// doubles and assign them accordingly.
		/// Leave state components at
		/// their initial values.
		/// </summary>
		/// <param name="X"></param>
		/// <param name="Y"></param>
		/// <param name="Z"></param>
		public Vector3D(int X, int Y, int Z)
		{
			x = (double)X;
			y = (double)Y;
			z = (double)Z;
		}

		/// <summary>
		/// Assign x,y,z accordingly.
		/// Leave state components at
		/// their initial values.
		/// </summary>
		/// <param name="X"></param>
		/// <param name="Y"></param>
		/// <param name="Z"></param>
		public Vector3D(double X, double Y, double Z)
		{
			x = X;
			y = Y;
			z = Z;
		}

		/// <summary>
		/// Assign x,y,z accordingly.
		/// Assign the state variables
		/// accordingly.
		/// </summary>
		/// <param name="X"></param>
		/// <param name="Y"></param>
		/// <param name="Z"></param>
		public Vector3D(double X, double Y, double Z,
			bool Region1, bool Region2, bool Region3, bool Region4)
		{
			x = X;
			y = Y;
			z = Z;
			in0to90 = Region1;
			in90to180 = Region2;
			in180to270 = Region3;
			in270to360 = Region4;
		}

		/// <summary>
		/// A deep copy constructor.
		/// </summary>
		/// <param name="V"></param>
		public Vector3D(Vector3D V)
		{
			x = V.x;
			y = V.y;
			z = V.z;
			in0to90 = V.in0to90;
			in90to180 = V.in90to180;
			in180to270 = V.in180to270;
			in270to360 = V.in270to360;
		}
		#endregion

		#region Intersection Test
		/// <summary>
		/// Return true if this vector
		/// is found to be within
		/// all of the four regions'
		/// data sets.
		/// </summary>
		/// <returns></returns>
		public bool inAll()
		{
			return in0to90 && in90to180 && in180to270 && in270to360;
		}
		#endregion

		#region Renderable Members
		/// <summary>
		/// Uses CsGL.OpenGL functionality
		/// in order to render the object.
		/// </summary>
		/// <param name="State"></param>
		public void OpenGLDraw(bool[] State)
		{
			//State is expected to be a bool[8]
			GL.glBegin(GL.GL_POINTS);
			GL.glColor3d(1.0,0.0,0.0);

			GL.glVertex3d(x,y,z);

			GL.glEnd();	
		}

		#endregion
	}
}
